# Animation Project Mapping

This document shows which AEP files correspond to which animation numbers.

---

## Football - Touchdown Animations

| Animation # | AEP File | Python Runner | Output Folder |
|-------------|----------|---------------|---------------|
| **TD 1** | `ScoringAnimations1-RefTD.aep` | `run_TdAnimation1.py` | `TD_Animation_1_384/` |
| **TD 2** | `ScoringAnimations2.aep` | `run_TdAnimation2.py` | `TD_Animation_2_384/` |
| **TD 3** | `Scoring Animation 3.aep` | `run_TdAnimation3.py` | `TD_Animation_3_384/` |
| **TD 4** | `ScoringAnimations4.aep` | `run_TouchdownAnimation4.py` | `TD_Animation_4_192/` |

---

## Football - Field Goal Animations

| Animation # | AEP File | Python Runner | Output Folder |
|-------------|----------|---------------|---------------|
| **FG 1** | `ScoringAnimations1-RefTD.aep` | `run_FgAnimation1.py` | `FG_Animation_1_384/` |
| **FG 2** | `ScoringAnimations2.aep` | `run_FgAnimation2.py` | `FG_Animation_2_384/` |
| **FG 3** | `Scoring Animation 3.aep` | `run_FgAnimation3.py` | `FG_Animation_3_384/` |
| **FG 4** | `ScoringAnimations4.aep` | `run_FgAnimation4.py` | `FG_Animation_4_192/` |

---

## Football - 2-Point Conversion Animations

| Animation # | AEP File | Python Runner | Output Folder |
|-------------|----------|---------------|---------------|
| **2PT 1** | `ScoringAnimations1-RefTD.aep` | `run_2ptAnimation1.py` | `2PT_Animation_1_384/` |
| **2PT 3** | `Scoring Animation 3.aep` | `run_2ptAnimation3.py` | `2PT_Animation_3_384/` |
| **2PT 4** | `ScoringAnimations4.aep` | `run_2ptAnimation4.py` | `2PT_Animation_4_192/` |

---

## Baseball - Home Run Animations

| Animation # | AEP File | Python Runner | Output Folder |
|-------------|----------|---------------|---------------|
| **HR 1** | `Baseball-Animation-1.aep` | `run_HomerunAnimation1.py` | `Homerun_Animation_1_PNG-192/` |
| **HR 2** | `Baseball-Animation-2.aep` | `run_HomerunAnimation2.py` | `Homerun_Animation_2_PNG-192/` |
| **HR 3** | `Baseball-Animation-3.aep` | `run_HomeRunAnimation3.py` | `HomeRun_Animation_3_PNG-192/` |

---

## Baseball - Run Scored Animations

| Animation # | AEP File | Python Runner | Output Folder |
|-------------|----------|---------------|---------------|
| **RS 1** | `Baseball-Animation-1.aep` | `run_RunScoredAnimation1.py` | `RunScored_Animation_1_PNG-192/` |
| **RS 2** | `Baseball-Animation-2.aep` | `run_RunScoredAnimation2.py` | `RunScored_Animation_2_PNG-192/` |
| **RS 3** | `Baseball-Animation-3.aep` | `run_RunScoredAnimation3.py` | `RunScored_Animation_3_PNG-192/` |

---

## Hockey - Goal Animations

| Animation # | AEP File | Python Runner | Output Folder |
|-------------|----------|---------------|---------------|
| **GOAL 1** | `GOAL-Animation1-BreakGlass.aep` | `run_GOAL_Animation1.py` | `GOAL_Animation_1_PNG-192/` |

---

## Pattern Summary

### Shared AEP Files
Some AEP files are reused across multiple animation types:

- **ScoringAnimations1-RefTD.aep** → TD 1, FG 1, 2PT 1
- **ScoringAnimations2.aep** → TD 2, FG 2
- **Scoring Animation 3.aep** → TD 3, FG 3, 2PT 3
- **ScoringAnimations4.aep** → TD 4, FG 4, 2PT 4
- **Baseball-Animation-1.aep** → HR 1, RS 1
- **Baseball-Animation-2.aep** → HR 2, RS 2
- **Baseball-Animation-3.aep** → HR 3, RS 3

### Naming Pattern
The animation number in the **output folder name** (e.g., `TD_Animation_1_384`) corresponds to:
- The **visual style/template number**, not necessarily the AEP file number
- Multiple animation types can share the same AEP file but render different comps

---

## Key Takeaways

**To answer your question: Yes, TD_Animation_1 uses ScoringAnimations1-RefTD.aep**

The naming works like this:
- `TD_Animation_1` = Touchdown style #1 → uses `ScoringAnimations1-RefTD.aep`
- `TD_Animation_2` = Touchdown style #2 → uses `ScoringAnimations2.aep`
- `TD_Animation_3` = Touchdown style #3 → uses `Scoring Animation 3.aep`
- `TD_Animation_4` = Touchdown style #4 → uses `ScoringAnimations4.aep`

The **animation number tracks the visual style**, not the file name.

---

**Last Updated:** October 14, 2025
